/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.UpgradeScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class PCMCIAUpgradeScreen
extends UpgradeScreen {
    private final String btnCancelCmd = "CANCEL";
    private final String btnTestNextCmd = "NEXT_TEST";
    private final String doneCmd = "DONE";
    private JProgressBar m_progressBar;
    private Device88X m_dev88X;
    private Action m_act;
    private Thread m_netThread;
    private JLabel m_txtInstruction;

    public PCMCIAUpgradeScreen(String string, AutoUpdateGUI autoUpdateGUI) {
        super(string, autoUpdateGUI);
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying IP Get Genstats Window");
        super.finalize();
        this.m_progressBar = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        this.m_txtInstruction = new JLabel("Copying files to your PCMCIA card.");
        this.m_act = new UpgradeScreen.AutomaticActionEvent(this, actionListener);
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setIndeterminate(true);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setPreferredSize(new Dimension(500, 20));
        JButton jButton = new JButton("Cancel");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('C');
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton("Next (Screen Test)");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('N');
        jButton2.setActionCommand("NEXT_TEST");
        jButton2.addActionListener(actionListener);
        jButton2.setVisible(false);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtInstruction, gridBagConstraints);
        jPanel.add(this.m_txtInstruction);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.m_progressBar, gridBagConstraints);
        jPanel.add(this.m_progressBar);
        JPanel jPanel2 = new JPanel();
        super.setLogo(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        container.add((Component)jPanel2, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel3, "Last");
        container.validate();
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if ("NEXT_TEST".equals(actionEvent.getActionCommand()) || "DONE".equalsIgnoreCase(actionEvent.getActionCommand())) {
            n2 = device88X.getBootRomUpgradeFlag() ? 16 : 14;
            System.out.println("Going to Download Files Screen: ID=" + n2);
        }
        System.out.println("Going to next Screen: ID=" + n2);
        return n2;
    }

    public void refresh() {
        super.refresh();
    }

    public void run(Device88X device88X) {
        this.m_dev88X = device88X;
        this.m_netThread = new Thread(new runPcmciaUpgrade(super.getJFrame()));
        this.m_netThread.setName("PCMCIA Upgrade Thread");
        this.m_netThread.start();
    }

    private synchronized void copyAllFiles(String string, String string2, boolean bl) throws IOException {
        File[] fileArray = new File(string).listFiles();
        this.m_progressBar.setMaximum(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            String string3 = string2 + File.separator + fileArray[i].getName();
            String string4 = string + File.separator + fileArray[i].getName();
            System.out.println(string4 + " -> " + string3);
            if (bl) {
                this.m_txtInstruction.setText("Copying: " + fileArray[i].getAbsolutePath());
            } else {
                this.m_txtInstruction.setText("Copying: " + fileArray[i].getName());
            }
            if (fileArray[i].isDirectory()) {
                new File(string3).mkdirs();
                this.copyAllFiles(string4, string3, bl);
            } else {
                this.m_progressBar.setMaximum((int)fileArray[i].length());
                this.m_progressBar.setIndeterminate(false);
                this.m_dev88X.copyInputStream(new FileInputStream(fileArray[i]), new FileOutputStream(string3), this.m_txtInstruction, this.m_progressBar);
            }
            Thread.yield();
        }
    }

    private synchronized void clearPcmciaFiles(String string) throws IOException {
        File[] fileArray = new File(string).listFiles();
        this.m_progressBar.setIndeterminate(true);
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = string + File.separator + fileArray[i].getName();
            System.out.println("Deleting: " + string2);
            if (fileArray[i].isDirectory()) {
                this.m_txtInstruction.setText("Retrieving Directory Listing for: " + fileArray[i].getAbsolutePath());
                this.clearPcmciaFiles(string2);
                Thread.yield();
                fileArray[i].delete();
                continue;
            }
            this.m_txtInstruction.setText("Deleting " + fileArray[i].getAbsolutePath() + " from PCMCIA card");
            fileArray[i].delete();
        }
    }

    private synchronized boolean checkFreeSpace(String string, Device88X device88X) throws IOException {
        long l = 14000000L;
        long l2 = device88X.getTotalUpgradeBytes();
        System.out.println("Total Bytes Needed: " + l2 / 1000000L + " Meg");
        System.out.println("Free Space on Card: " + l / 1000000L + " Meg");
        return l > l2;
    }

    class runPcmciaUpgrade
    implements Runnable {
        private JFrame m_runFrame;

        public runPcmciaUpgrade(JFrame jFrame) {
            this.m_runFrame = jFrame;
        }

        public synchronized void run() {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "DONE");
            PCMCIAUpgradeScreen.this.m_act.setEnabled(true);
            try {
                Object object;
                if (!PCMCIAUpgradeScreen.this.m_dev88X.isSkipBackupFlagSet()) {
                    this.m_runFrame.setTitle("Backing Up Files");
                    System.out.println("===== Backing up files from PCMCIA Card to PC =====");
                    PCMCIAUpgradeScreen.this.copyAllFiles(PCMCIAUpgradeScreen.this.m_dev88X.getPcmciaCardLocation(), PCMCIAUpgradeScreen.this.m_dev88X.getBackupDir(), true);
                }
                Thread.yield();
                if (!PCMCIAUpgradeScreen.this.m_dev88X.isSkipBackupFlagSet()) {
                    this.m_runFrame.setTitle("Diffing Directories");
                    System.out.println("===== Diffing Backup to Release Directory =====");
                    PCMCIAUpgradeScreen.this.m_txtInstruction.setText("Diffing between the backup files and upgrade files");
                    long l = PCMCIAUpgradeScreen.this.m_dev88X.diffFileStructure(PCMCIAUpgradeScreen.this.m_dev88X.getBackupDir(), PCMCIAUpgradeScreen.this.m_dev88X.getUnzippedPath(), PCMCIAUpgradeScreen.this.m_txtInstruction, PCMCIAUpgradeScreen.this.m_progressBar);
                    PCMCIAUpgradeScreen.this.m_dev88X.setTotalUpgradeBytes(l);
                }
                PCMCIAUpgradeScreen.this.m_txtInstruction.setText("Clearing Files on the PCMCIA card");
                this.m_runFrame.setTitle("Clearing Files on the PCMCIA card");
                System.out.println("===== Clearing files from PCMCIA card =====");
                PCMCIAUpgradeScreen.this.clearPcmciaFiles(PCMCIAUpgradeScreen.this.m_dev88X.getPcmciaCardLocation());
                int n = 0;
                this.m_runFrame.setTitle("Verify Free Space on the PCMCIA card");
                System.out.println("===== Verify Free Space PCMCIA card =====");
                while (!PCMCIAUpgradeScreen.this.checkFreeSpace(PCMCIAUpgradeScreen.this.m_dev88X.getPcmciaCardLocation(), PCMCIAUpgradeScreen.this.m_dev88X)) {
                    object = new Object[]{"Retry", "Cancel Upgrade"};
                    n = JOptionPane.showOptionDialog(this.m_runFrame, "Not Enough Space Available on the PCMCIA card\nPlease Insert a Blank PCMCIA card, or delete some files on the PCMCIA card \nto make room for the upgrade files", "Not Enough Space On Card", 1, 2, null, (Object[])object, object[0]);
                    if (n == 1) {
                        System.out.println("Exiting");
                        System.exit(0);
                    }
                    if (n <= 0) continue;
                }
                PCMCIAUpgradeScreen.this.m_txtInstruction.setText("Copying Files to the PCMCIA card");
                this.m_runFrame.setTitle("Copy New Files To PCMCIA card");
                System.out.println("===== Copy new files to PCMCIA card =====");
                PCMCIAUpgradeScreen.this.copyAllFiles(PCMCIAUpgradeScreen.this.m_dev88X.getUnzippedPath(), PCMCIAUpgradeScreen.this.m_dev88X.getPcmciaCardLocation(), false);
                this.m_runFrame.setTitle("Cleaning Up Install Files");
                System.out.println("===== Install Complete, Cleaning Up Unzipped Folder =====");
                PCMCIAUpgradeScreen.this.m_dev88X.deleteFolder(PCMCIAUpgradeScreen.this.m_dev88X.getUnzippedPath(), PCMCIAUpgradeScreen.this.m_txtInstruction, PCMCIAUpgradeScreen.this.m_progressBar);
                object = new File(PCMCIAUpgradeScreen.this.m_dev88X.getUnzippedPath());
                ((File)object).delete();
                PCMCIAUpgradeScreen.this.m_dev88X.setUnzippedPath("");
            }
            catch (IOException iOException) {
                System.err.println("Error: " + iOException.getMessage());
                JOptionPane.showMessageDialog(null, "Upgrade Error:  " + iOException.getMessage(), "Upgrade Error", 0);
                System.exit(0);
            }
            PCMCIAUpgradeScreen.this.m_act.actionPerformed(actionEvent);
        }
    }
}

